// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Supplemental MAPI functions.
//.............................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include <Mapi.h>
#include <richedit.h>
#include <string.h>
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HWND				hMainWindow;
extern	HINSTANCE			hInst;
extern	lpMapiMessage		lpReadMsg;
extern	lpMapiMessage		lpmsg;
extern	TCHAR				Header1[];
extern	TCHAR				Header1P[];
extern	TCHAR				Footer1[];
extern	LPBYTE				lpSearchEDI;
extern	TCHAR				szFileToDecipher[MAX_PATH];
extern	TCHAR				szDestination[MAX_PATH];
extern	TCHAR				szFileToEncipher[MAX_PATH];
extern	LPBYTE				lpLineFeed;
extern	LPTSTR				lpszNA;
extern	ULONG				flSendMsgFlags;
extern	BOOL				bTempRtf;
extern	LPTSTR				lpszNoteText;
extern	COLORREF			crBkgCurrent;
extern	BOOL				bIncludeBkgClr;
extern	LPMSGID				lpReadMsgNode;
extern	LARGE_INTEGER		liEncFileSize;
extern	BOOL				bCanceledMsgEncryption;
extern	BOOL				bUseMd5;
extern	LPBYTE				lpInBuffer;
extern  LPBYTE				lpOutBuffer;
extern	DWORD				dwCheckCrc32;
extern	z_stream			z;
extern	COLORREF			crOleBkg;
extern	BOOL				bProgramRegistered;

TCHAR	szEmailTsc[] = "Email.tsc";
LPTSTR	lpszEmailMsg = "E-mail Message";
TCHAR	szMyReplyFile[MAX_PATH];
TCHAR	szPkdRtfFile[MAX_PATH];
DWORD	dwMyReplyFormat;
BOOL	bDeleteReplyFile;
BOOL	bEncryptingEmail = FALSE;

MSG_HEADER		Msghdr;
BYTE			MessageId[] = "pkdm";

// Decrypt an e-mail message.
//...........................
BOOL DecryptTheMessage(HWND hDlg)
{
	BOOL			bResult;
	BOOL			bErr = TRUE;
	BOOL			bInit = FALSE;
	HANDLE			hFile = 0;
	HANDLE			hFile1 = 0;
	int				i;
	int				iAttrib;
	int				iCompareResult;
	int				iError;
	LPBYTE			lpEmailMsg;
	LPBYTE			lpEmailMsgDup;
	LPBYTE			lpDestination = 0;
	DWORD			dwLength;
	DWORD			dwSearchLength;
	DWORD			dwBytesWritten;
	DWORD			dwBytesRead;
	DWORD			dwRtfLength;
	DWORD			dwRtfSize;
	DWORD			dwCrc24Dup;
	DWORD			dwFormat;
	DWORD			dwCrc24;
	BOOL			bEmailFile = FALSE;
	CHARFORMAT2		cf;

	cf.cbSize = sizeof(CHARFORMAT2);

	bDeleteReplyFile = FALSE;

	// Set return receipt for this message to default.
	//................................................
	lpReadMsgNode->bReceiptRequested = FALSE;

	// Decrypt the message.
	//.....................
	lpEmailMsg = lpReadMsg->lpszNoteText;
	lpEmailMsgDup = lpEmailMsg;
	dwLength = (lstrlen((LPCTSTR)lpEmailMsg) + 1);
	
	// Find the header for the encrypted message.
	//...........................................
	bResult = SearchFor((LPBYTE)&Header1,37,(LPBYTE)lpEmailMsg,dwLength);
	if (!bResult)
	{
	  NoMsgError:
		SetLastError(IDS_NOENCRYPTEMSG);
		ErrorProcedure(lpszEmailMsg,IDS_SEARCHFOR,MB_OK);
		goto DecryptEnd;
	}
	// Now get past the next two line feed characters.
	//................................................
	lpEmailMsgDup = lpSearchEDI;
	dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);

	for (i = 0; i < 2; i++)
	{
		bResult = SearchFor(lpLineFeed,1,lpEmailMsgDup,dwSearchLength);
		if (!bResult)
		{
			goto NoMsgError;
		}
		lpEmailMsgDup = lpSearchEDI;
		lpEmailMsgDup++;
		dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);
	}
	// The next phrase should be the clipboard format.
	//................................................
	bResult = SearchFor((LPBYTE)&Header1[136],18,lpEmailMsgDup,dwSearchLength);
	if (!bResult)
	{
		goto NoMsgError;
	}
	lpEmailMsgDup = lpSearchEDI;
	dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);

	// Get the next byte of data which is our clipboard format.
	// Leave it in the zero based format for checking for the
	// type of format - rtf or text. It will always be valid.
	//.........................................................
	__asm
	{
		mov		edi,lpEmailMsgDup
		add		edi,18
		movzx	eax,byte ptr [edi]
		and		eax,0x0f
		mov		dwFormat,eax
		mov		dwMyReplyFormat,eax
	}
	// Now we have to get past the format line and find the start of the message.
	// Search for line feeds with a first character of 'q' following.
	//...........................................................................
	i = 5;
	while(i > 0)
	{
		bResult = SearchFor(lpLineFeed,1,lpEmailMsgDup,dwSearchLength);
		if (!bResult)
		{
			goto NoMsgError;
		}
		lpEmailMsgDup = lpSearchEDI;
		lpEmailMsgDup++;
		if (*lpEmailMsgDup == 'h')
		{
			break;
		}
		dwSearchLength = (dwLength + lpEmailMsg - lpEmailMsgDup);
		i--;
	}
	if (*lpEmailMsgDup != 'h')
	{
		goto NoMsgError;
	}
	// lpEmailMsgDup points to the start of the encrypted message.
	// Decode the block to get our encrypted message crc24 value.
	//............................................................
	lpDestination = AllocateMemory(dwLength + 4096);
	if (!lpDestination)
	{
		ErrorProcedure(lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
		goto DecryptEnd;
	}
	dwRtfSize = dwLength + 4096;
	dwCrc24 = CRC24_INIT;
		
	// Dearmor the buffer.
	//....................
	lpEmailMsgDup = DearmorBuffer(lpEmailMsgDup,lpDestination,&dwRtfLength);
	if (lpEmailMsgDup == 0)
	{
		SetLastError(IDS_DEARMORBUFFERERROR);
		ErrorProcedure(lpszEmailMsg,IDS_READ,MB_OK);
		goto DecryptEnd;
	}
	// We are finished with the conversion of the message.
	// Calculate the crc24 value.
	//....................................................
	dwCrc24 = Crc24Update(dwCrc24,lpDestination,dwRtfLength);

	// Back up the pointer 2 spaces so we can search for a \n.
	//........................................................
	lpEmailMsgDup--;
	lpEmailMsgDup--;

	// Now retrieve the crc24 value from the clipboard buffer.
	// lpClipboard points to the = after the key and before
	// the crc24 value. Could be more than one.
	//........................................................
	bResult = SearchFor(lpLineFeed,1,lpEmailMsgDup,10);
	if (!bResult)
	{
	  NoValidCrc:
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszEmailMsg,IDS_READ,MB_OK);
		goto DecryptEnd;
	}
	lpEmailMsgDup = lpSearchEDI;
	lpEmailMsgDup++;
	if (*lpEmailMsgDup != '=')
	{
		goto NoValidCrc;
	}
	lpEmailMsgDup++;

	dwCrc24Dup = GetCrc24(lpEmailMsgDup);

	if (dwCrc24 != dwCrc24Dup)
	{
		SetLastError(IDS_CRC24NOMATCH);
		ErrorProcedure(lpszEmailMsg,IDS_COMPARE,MB_OK);
		goto DecryptEnd;
	}
	// See if we have a background color to get. First get the standard window color
	// in case there is not one.
	//..............................................................................
	crBkgCurrent = GetSysColor(COLOR_WINDOW);
	lpEmailMsgDup += 4;
	if (*lpEmailMsgDup == '=')
	{
		lpEmailMsgDup++;
		crBkgCurrent = GetCrc24(lpEmailMsgDup);
		crOleBkg = crBkgCurrent;

		// Now get the return receipt.
		//............................
		lpEmailMsgDup += 4;
		if (*lpEmailMsgDup == '=')
		{
			lpEmailMsgDup++;
			if (*lpEmailMsgDup == '1')
			{
				lpReadMsgNode->bReceiptRequested = TRUE;
			}
		}
	}
	// Decrypt the message.
	//.....................
	ZeroMemory(&szFileToDecipher,MAX_PATH);
	ZeroMemory(&szDestination,MAX_PATH);
	GetTempPath(MAX_PATH,(LPTSTR)&szFileToDecipher);
	GetTempPath(MAX_PATH,(LPTSTR)&szDestination);
	StringCbCatEx((LPTSTR)&szFileToDecipher,sizeof(szFileToDecipher),(LPCTSTR)&szEmailTsc,
				   NULL,NULL,dwStringSafeFlag);

	hFile = CreateMyFile((LPTSTR)&szFileToDecipher,GENERIC_READ | GENERIC_WRITE,
						  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto DecryptEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szFileToDecipher,hFile,lpDestination,dwRtfLength,
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szFileToDecipher,hFile);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	hFile = 0;
	bEmailFile = TRUE;

	ZeroMemory(lpDestination,dwRtfSize);
	DeallocateMemory(lpDestination);
	lpDestination = 0;

	// Setup and call the decryption procedure.
	//.........................................
	bErr = DecryptAFile((LPBYTE)&szFileToDecipher);
	if (bErr)
	{
		goto DecryptEnd;
	}
	bDeleteReplyFile = TRUE;
	CopyMemory(&szMyReplyFile,&szDestination,MAX_PATH);

	bErr = TRUE;

	// Check to see if we have to decompress the message.
	//...................................................
	hFile1 = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
					       OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile1)
	{
		goto DecryptEnd;
	}
	// Check the header to see if it is compressed or not.
	//....................................................
	bResult = ReadMyFile((LPTSTR)&szDestination,hFile1,&Msghdr,sizeof(MSG_HEADER),
					      &dwBytesRead,NULL);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Msghdr,4,
								  (LPCTSTR)&MessageId,4);
	if (iCompareResult == CSTR_EQUAL)
	{
		// We have to decompress the file.
		//................................
		lpInBuffer = AllocateMemory(Msghdr.dwCompressedMsgSize);
		lpOutBuffer = AllocateMemory(Msghdr.dwMsgSize);
		if (!lpInBuffer || !lpOutBuffer)
		{
			goto DecryptEnd;
		}
		// Read in the compressed data.
		//.............................
		bResult = ReadMyFile((LPTSTR)&szDestination,hFile1,lpInBuffer,
							  Msghdr.dwCompressedMsgSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DecryptEnd;
		}
		// Close and wipe this packed file.
		//.................................
		bResult = CloseMyHandle((LPTSTR)&szDestination,hFile1);
		if (!bResult)
		{
			goto DecryptEnd;
		}
		hFile1 = 0;
		bResult = WipeMyFile((LPBYTE)&szDestination,TRUE);
		if (bResult)
		{
			goto DecryptEnd;
		}
		// Change the extension of the file to rtf.
		//.........................................
		PathRemoveExtension((LPTSTR)&szDestination);
		StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),TEXT(".rtf"),NULL,NULL,
					   dwStringSafeFlag);
		CopyMemory(&szMyReplyFile,&szDestination,MAX_PATH);
		hFile1 = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
							   CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hFile1)
		{
			goto DecryptEnd;
		}
		// Setup to decompress the buffer.
		//................................
		ZeroMemory(&z,sizeof(z_stream));

		z.next_in = lpInBuffer;
		z.next_out = lpOutBuffer;
		z.avail_in = Msghdr.dwCompressedMsgSize;
		z.avail_out = Msghdr.dwMsgSize;

		// Initialize the check crc32 value.
		//..................................
		dwCheckCrc32 = crc32(0L,Z_NULL,0);

		iError = inflateInit(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEINIT);
			goto DecryptEnd;
		}
		bInit = TRUE;

		iError = inflate(&z,Z_FINISH);
		if (iError < 0)
		{
			ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATE);
			goto DecryptEnd;
		}
		if (iError != Z_STREAM_END)
		{
			ZlibError((LPBYTE)&szDestination,Z_DATA_ERROR,IDS_INFLATE);
			goto DecryptEnd;
		}
		// Get the final crc32 check value.
		//.................................
		dwCheckCrc32 = crc32(dwCheckCrc32,lpOutBuffer,z.total_out);

		if (dwCheckCrc32 != Msghdr.dwMsgCrc32)
		{
			SetLastError(IDS_EMAILCRCNOGOOD);
			ErrorProcedure((LPTSTR)&szDestination,IDS_COMPARE,MB_OK);
			goto DecryptEnd;
		}
		iError = inflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEEND);
			goto DecryptEnd;
		}
		bInit = FALSE;

		// We have the decompressed buffer. Write it to disk.
		//...................................................
		bResult = WriteMyFile((LPTSTR)&szDestination,hFile1,lpOutBuffer,z.total_out,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DecryptEnd;
		}
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hFile1);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	hFile1 = 0;

	// We have a valid decrypted message. Stream it into the rich text
	// edit control in the proper format.
	//.................................................................
	if (dwFormat == 0)
	{
		iAttrib = SF_RTF;
	}
	else
	{
		iAttrib = SF_TEXT;
	}
	bErr = OpenFileStreamIn((LPTSTR)&szDestination,hDlg,IDC_RNOTE,iAttrib);

	// Set the current background color for the rich edit control.
	//............................................................
	SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETBKGNDCOLOR,0,(LPARAM)(COLORREF)crBkgCurrent);

	DecryptEnd:

	if (bInit)
	{
		iError = inflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szDestination,iError,IDS_INFLATEEND);
		}
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,Msghdr.dwCompressedMsgSize);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,Msghdr.dwMsgSize);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpDestination)
	{
		ZeroMemory(lpDestination,dwRtfSize);
		DeallocateMemory(lpDestination);
	}
	if (hFile)
	{
		CloseMyHandle((LPTSTR)&szFileToDecipher,hFile);
	}
	if (hFile1)
	{
		CloseMyHandle((LPTSTR)&szDestination,hFile1);
	}
	if (bEmailFile)
	{
		WipeMyFile((LPBYTE)&szFileToDecipher,TRUE);
	}
	if (bErr)
	{
		if (bDeleteReplyFile)
		{
			WipeMyFile((LPBYTE)&szMyReplyFile,TRUE);
			bDeleteReplyFile = FALSE;
		}
	}
	return(bErr);
}

// Create a new message to reply to an old message.
//.................................................
BOOL MakeNewMessage (lpMapiMessage lpSrcMsg, UINT flType)
{
    ULONG		idx;
    BOOL		bErr = TRUE;
	ULONG		idxSrc;

    lpmsg = (lpMapiMessage)PvAlloc(sizeof(MapiMessage));

    if (!lpmsg)
	{
		goto err;
	}
	ZeroMemory(lpmsg,sizeof(MapiMessage));

    lpmsg->flFlags = flSendMsgFlags;

	// Setup the subject depending on how we are responding.
	//......................................................
    if (lpSrcMsg->lpszSubject)
    {
		lpmsg->lpszSubject = (LPTSTR)PvAlloc(lstrlen(lpSrcMsg->lpszSubject) + 10);

		if (!lpmsg->lpszSubject)
		{
			goto err;
		}
		// Setup the type of reply for the subject.
		//.........................................
		if (flType == IDC_FORWARD)
		{
			StringCbCopy(lpmsg->lpszSubject,(lstrlen(lpSrcMsg->lpszSubject) + 10),"FW: ");
		}
		else
		{
			StringCbCopy(lpmsg->lpszSubject,(lstrlen(lpSrcMsg->lpszSubject) + 10),"RE: ");
		}
		StringCbCat(lpmsg->lpszSubject,(lstrlen(lpSrcMsg->lpszSubject) + 10),
					lpSrcMsg->lpszSubject);
    }
	// If we are not replying to a decrypted file in rich text format
	// we use the original text of the file.
	//...............................................................
	if (!bDeleteReplyFile)
	{
		if (lpSrcMsg->lpszNoteText)
		{
			lpmsg->lpszNoteText = (LPTSTR)PvAlloc(lstrlen(lpSrcMsg->lpszNoteText) + 64);

			if (!lpmsg->lpszNoteText)
			{
				goto err;
			}
			StringCbCopy(lpmsg->lpszNoteText,(lstrlen(lpSrcMsg->lpszNoteText) + 64),
						 "\r\n-----Original Message-----\r\n\r\n");
			StringCbCat(lpmsg->lpszNoteText,(lstrlen(lpSrcMsg->lpszNoteText) + 64),
						lpSrcMsg->lpszNoteText);
		}
	}
	// Set the message type if there is one.
	//......................................
    if (lpSrcMsg->lpszMessageType)
    {
		lpmsg->lpszMessageType = (LPTSTR)PvAlloc(lstrlen(lpSrcMsg->lpszMessageType) + 1);

		if (!lpmsg->lpszMessageType)
		{
			goto err;
		}
		StringCbCopy(lpmsg->lpszMessageType,(lstrlen(lpSrcMsg->lpszMessageType) + 1),
					 lpSrcMsg->lpszMessageType);
    }
	// Set the message conversation ID if there is one.
	//.................................................
    if (lpSrcMsg->lpszConversationID)
    {
		lpmsg->lpszConversationID = (LPTSTR)PvAlloc(lstrlen(lpSrcMsg->lpszConversationID) + 1);

		if (!lpmsg->lpszConversationID)
		{
			goto err;
		}
		StringCbCopy(lpmsg->lpszConversationID,(lstrlen(lpSrcMsg->lpszConversationID) + 1),
					 lpSrcMsg->lpszConversationID);
    }
	// If we are forwarding, include the attached files if any.
	//.........................................................
    if (lpSrcMsg->nFileCount && flType == IDC_FORWARD )
    {
		lpmsg->nFileCount = lpSrcMsg->nFileCount;

		lpmsg->lpFiles = (lpMapiFileDesc)PvAlloc(lpmsg->nFileCount * sizeof(MapiFileDesc));

		if (!lpmsg->lpFiles)
		{
			goto err;
		}
		ZeroMemory(lpmsg->lpFiles,lpmsg->nFileCount * sizeof (MapiFileDesc));

        for (idx = 0; idx < lpmsg->nFileCount; idx++)
		{       
			CopyAttachment(lpmsg->lpFiles, &lpmsg->lpFiles[idx],&lpSrcMsg->lpFiles[idx]);
        
            if ((&lpmsg->lpFiles[idx])->nPosition != (ULONG) -1)
            {
                (&lpmsg->lpFiles[idx])->nPosition = (ULONG) -1;   
            }
        }
    }
	// Setup the recipients depending on the type of reply.
	//.....................................................
    if (flType == IDC_REPLY || flType == IDC_REPLYALL)
    {
		if(lpSrcMsg->lpOriginator)
		{
			lpmsg->nRecipCount = 1;
		}

		if (flType == IDC_REPLYALL)
		{
			lpmsg->nRecipCount += lpSrcMsg->nRecipCount;
		}

        if(lpmsg->nRecipCount > 0)
		{
			lpmsg->lpRecips = (lpMapiRecipDesc)PvAlloc(lpmsg->nRecipCount * sizeof (MapiRecipDesc));

			if (!lpmsg->lpRecips)
			{
				goto err;
			}
			ZeroMemory(lpmsg->lpRecips,lpmsg->nRecipCount * sizeof (MapiRecipDesc));

			idx = 0;

			// Get the originator of the message.
			//...................................
			if(lpSrcMsg->lpOriginator)
			{
				lpSrcMsg->lpOriginator->ulRecipClass = MAPI_TO;
				CopyRecipient(lpmsg->lpRecips,lpmsg->lpRecips,lpSrcMsg->lpOriginator);
				lpSrcMsg->lpOriginator->ulRecipClass = MAPI_ORIG;
				idx = 1;
			}
			// Get all the recipients, including yourself.
			//............................................
			for (idxSrc = 0; idx < lpmsg->nRecipCount; idxSrc++, idx++)
			{
				CopyRecipient(lpmsg->lpRecips,&lpmsg->lpRecips[idx],&lpSrcMsg->lpRecips[idxSrc]);
			}
		}
		bErr = FALSE;
	
	err:
		if(bErr && lpmsg)
		{
			PvFree(lpmsg->lpszSubject);
			PvFree(lpmsg->lpszNoteText);
			PvFree(lpmsg->lpszMessageType);
			PvFree((LPBYTE)lpmsg->lpszConversationID);
			PvFree((LPBYTE)lpmsg->lpRecips);
			PvFree((LPBYTE)lpmsg->lpFiles);
			PvFree((LPBYTE)lpmsg);
			lpmsg = NULL;
		}
	}
	else
	{
		bErr = FALSE;
	}
	return (bErr);
}

//Encrypt an e-mail message.
//..........................
BOOL EncryptAnEmailMessage()
{
	BOOL			bErr = TRUE;
	BOOL			bError;
	BOOL			bResult;
	BOOL			bWeHavePkd = FALSE;
	int				iResult;
	int				iError;
	HANDLE			hDestFile = 0;
	HANDLE			hEncFile = 0;
	HANDLE			hTempFile = 0;
	BOOL			bDeleteDest = FALSE;
	BOOL			bInit = FALSE;
	LARGE_INTEGER	li;
	LARGE_INTEGER	liPkdFileSize;
	ULARGE_INTEGER	uli;
	OPENFILENAME	ofn;
	DWORD			dwSize;	
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwArmorLines;
	DWORD			dwMemNeeded;
	DWORD			dwCurrentSize;
	DWORD			dwArmorSize;
	int				iTemp;
	UINT			uRealFormatUsed = 0;
	HANDLE			lpClipboardMem = 0;
	HANDLE			lpClipboardMemDup;
	LPBYTE			lpEncryptedBuffer = 0;
	TCHAR			szFormatString[256];
	TCHAR			szBuffer[512];

	InitializeOFN(&ofn,SAVE_SOURCE);

	// We want to include the background color in the armor file.
	//...........................................................
	bIncludeBkgClr = TRUE;

	// Check out the file's size. We do not want to encipher a
	// zero length file.
	//........................................................
	hEncFile = CreateMyFile((LPTSTR)&szFileToEncipher,GENERIC_READ,0,NULL,OPEN_EXISTING,
							 FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hEncFile)
	{
		goto EncryptEnd;
	}
	liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szFileToEncipher,hEncFile);
	liPkdFileSize.QuadPart = liEncFileSize.QuadPart;
	if (liEncFileSize.QuadPart == -1)
	{
		goto EncryptEnd;
	}
	if (!bUseMd5)
	{
		// Compress the file if we are not in the old protocols.
		// First of all, setup the pkd file.
		//..................................
		CopyMemory(&szPkdRtfFile,&szFileToEncipher,MAX_PATH);
		PathRemoveExtension((LPTSTR)&szPkdRtfFile);
		StringCbCatEx((LPTSTR)&szPkdRtfFile,sizeof(szPkdRtfFile),TEXT(".pkd"),NULL,NULL,
					   dwStringSafeFlag);

		// Create the ouput file.
		//.......................
		hTempFile = CreateMyFile((LPTSTR)&szPkdRtfFile,GENERIC_READ | GENERIC_WRITE,
								  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hTempFile)
		{
			goto EncryptEnd;
		}
		// Setup the size of the input and output buffers.
		//................................................	
		lpInBuffer = AllocateMemory(liEncFileSize.LowPart);

		if (!lpInBuffer)
		{
			goto EncryptEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szFileToEncipher,hEncFile,lpInBuffer,
						      liEncFileSize.LowPart,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		// Setup the compressed message header.
		//.....................................
		CopyMemory(&Msghdr.MsgId,&MessageId,4);
		Msghdr.dwMsgSize = liEncFileSize.LowPart;

		// Do the crc32 for the file.
		//...........................
		Msghdr.dwMsgCrc32 = crc32(0L,Z_NULL,0);
		Msghdr.dwMsgCrc32 = crc32(Msghdr.dwMsgCrc32,lpInBuffer,liEncFileSize.LowPart);

		// Setup the z_stream.
		//....................
		ZeroMemory(&z,sizeof(z));

		// Initialize the internal stream state for compression.
		//......................................................
		iError = deflateInit(&z,Z_BEST_COMPRESSION);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEINIT);
			goto EncryptEnd;
		}
		bInit = TRUE;

		uli.HighPart = 0;
		uli.LowPart = deflateBound(&z,liEncFileSize.LowPart);

		lpOutBuffer = AllocateMemory(uli.LowPart);

		if (!lpOutBuffer)
		{
			goto EncryptEnd;
		}
		z.avail_in = liEncFileSize.LowPart;
		z.avail_out = uli.LowPart;
		z.next_in = lpInBuffer;
		z.next_out = lpOutBuffer;

		// Lets go and compress this message.
		//...................................
		iError = deflate(&z,Z_FINISH);
		if (iError < 0)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATE);
			goto EncryptEnd;
		}
		if (iError != Z_STREAM_END)
		{
			ZlibError((LPBYTE)&szFileToEncipher,Z_DATA_ERROR,IDS_DEFLATE);
			goto EncryptEnd;
		}
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			goto EncryptEnd;
		}
		bInit = FALSE;

		Msghdr.dwCompressedMsgSize = z.total_out;

		// Write the header to disk.
		//..........................
		bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,&Msghdr,sizeof(Msghdr),
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpOutBuffer,z.total_out,
							   &dwBytesWritten,NULL);
		if(!bResult)
		{
			goto EncryptEnd;
		}
		// Get the new size of the packed file.
		//.....................................
		liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szPkdRtfFile,hTempFile);

		bResult = CloseMyHandle((LPTSTR)&szPkdRtfFile,hTempFile);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bWeHavePkd = TRUE;
		hTempFile = 0;
	}

	bResult = CloseMyHandle((LPTSTR)&szFileToEncipher,hEncFile);
	if (!bResult)
	{
		goto EncryptEnd;
	}
	hEncFile = 0;

	// If we have a valid packed file, we encrypt it.
	//...............................................
	if (bWeHavePkd)
	{
		SwapOps((LPBYTE)&szFileToEncipher,(LPBYTE)&szPkdRtfFile,MAX_PATH);
	}
	// Setup and call the encryption procedure.
	//.........................................
	bEncryptingEmail = TRUE;
	bError = EncryptAFile((LPBYTE)&szFileToEncipher,&ofn);
	bEncryptingEmail = FALSE;

	// Wipe the intermediate packed file and swap the names back.
	//...........................................................
	if (bWeHavePkd)
	{
		WipeMyFile((LPBYTE)&szFileToEncipher,TRUE);
		SwapOps((LPBYTE)&szFileToEncipher,(LPBYTE)&szPkdRtfFile,MAX_PATH);
	}
	// If we have an error and did not cancel.
	//.......................................
	if (bError && !bCanceledMsgEncryption)
	{
		goto EncryptEnd;
	}
	// If no error and we did not cancel, setup the encypted text in the rtf box.
	//...........................................................................
	if (!bError && !bCanceledMsgEncryption)
	{
		// Get the size of the file and allocate a buffer.
		//................................................
		hDestFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
								  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hDestFile)
		{
			goto EncryptEnd;
		}
		bDeleteDest = TRUE;

		li.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hDestFile);
		if (li.QuadPart == -1)
		{
			goto EncryptEnd;
		}
		dwSize = li.LowPart;
		lpEncryptedBuffer = AllocateMemory(dwSize);
		if (!lpEncryptedBuffer)
		{
			goto EncryptEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szDestination,hDestFile,lpEncryptedBuffer,
							dwSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hDestFile);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		hDestFile = 0;

		// Figure out the memory needed for the armor buffer.
		//...................................................
		__asm
		{
			xor		edx,edx
			mov		eax,dwSize
			mov		ecx,48
			div		ecx
			cmp		edx,0
			je		L1
			inc		eax
		L1:	mov		dwArmorLines,eax
		}
		dwMemNeeded = ((dwArmorLines * 66) + 1024);
		dwCurrentSize = dwMemNeeded;
		lpClipboardMem = AllocateMemory(dwMemNeeded);
		if (!lpClipboardMem)
		{
			goto EncryptEnd;
		}
		lpClipboardMemDup = lpClipboardMem;
		if (bProgramRegistered)
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1,
						    uRealFormatUsed);
		}
		else
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1P,
							uRealFormatUsed);
		}
		CopyMemory(lpClipboardMemDup,&szBuffer,lstrlen((LPCTSTR)&szBuffer));
		iTemp = lstrlen((LPCTSTR)&szBuffer);
		__asm
		{
			mov		ecx,iTemp
			mov		edi,lpClipboardMemDup
			add		edi,ecx
			mov		lpClipboardMemDup,edi
		}
		// Armor the buffer.
		//..................
		lpClipboardMemDup = ArmorBuffer(lpEncryptedBuffer,lpClipboardMemDup,dwSize);

		// Put in the footer.
		//...................
		CopyMemory(lpClipboardMemDup,&Footer1,lstrlen((LPCTSTR)&Footer1));

		// Clear the encrypted buffer.
		//............................
		ZeroMemory(lpEncryptedBuffer,dwSize);
		DeallocateMemory(lpEncryptedBuffer);
		lpEncryptedBuffer = 0;

		// Find out the length of the armored buffer.
		//...........................................
		dwArmorSize = (lstrlen(lpClipboardMem) + 1);

		// The armored buffer must be reallocated with PvAlloc.
		//.....................................................
		bErr = PvFree((LPBYTE)lpszNoteText);
		if (bErr)
		{
			goto EncryptEnd;
		}
		lpszNoteText = (LPTSTR)PvAlloc(dwArmorSize + 1);
		if (!lpszNoteText)
		{
			goto EncryptEnd;
		}
		ZeroMemory(lpszNoteText,dwArmorSize + 1);
		CopyMemory(lpszNoteText,lpClipboardMem,dwArmorSize);
		lpmsg->lpszNoteText = lpszNoteText;

		// We can deallocate lpClipboardMem, we do not need it.
		//.....................................................
		ZeroMemory(lpClipboardMem,dwCurrentSize);
		DeallocateMemory(lpClipboardMem);
		lpClipboardMem = 0;
		bErr = FALSE;
	}
	else
	{
		// We cancelled encryption of a message before it was done. Ask if we want
		// to save the original file to use again.
		//........................................................................
		LoadString(hInst,IDS_ASKSAVEMSG,(LPTSTR)&szFormatString,sizeof(szFormatString));
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szFormatString,
					    szFileToEncipher);
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
								 MB_ICONQUESTION | MB_HELP | MB_YESNO,MB_ICONQUESTION,0);
		if (iResult == IDYES)
		{
			bTempRtf = FALSE;
		}
	}

	EncryptEnd:

	bIncludeBkgClr = FALSE;

	if (bInit)
	{
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			bResult = FALSE;
		}
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,uli.LowPart);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,liPkdFileSize.LowPart);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpClipboardMem)
	{
		ZeroMemory(lpClipboardMem,dwCurrentSize);
		DeallocateMemory(lpClipboardMem);
	}
	if (hEncFile)
	{
		CloseMyHandle((LPTSTR)&szFileToEncipher,hEncFile);
	}
	if (bTempRtf)
	{
		WipeMyFile((LPBYTE)&szFileToEncipher,TRUE);	
		bTempRtf = FALSE;
	}
	if (hDestFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestFile);
	}
	if (bDeleteDest)
	{
		WipeMyFile((LPBYTE)&szDestination,TRUE);
	}
	if (lpEncryptedBuffer)
	{
		ZeroMemory(lpEncryptedBuffer,dwSize);
		DeallocateMemory(lpEncryptedBuffer);
	}
	return(bErr);
}
